XIncludeFile "init.pbi"

Procedure Init()
  UsePNGImageDecoder()
  UsePNGImageEncoder()
  
  If OpenWindow(#Window, 0, 0, #WINDOW_WIDTH, #WINDOW_HEIGHT, "Map editor v"+#VERSION, #PB_Window_SystemMenu | #PB_Window_MinimizeGadget | #PB_Window_MaximizeGadget | #PB_Window_SizeGadget | #PB_Window_ScreenCentered | #PB_Window_TitleBar)=0
    MessageRequester("OpenWindow() error", "Can't open editor.")
    End
  EndIf
  
  WindowBounds(#Window, #WINDOW_WIDTH, #WINDOW_HEIGHT, #PB_Ignore, #PB_Ignore) 
  
  If LoadFont(0, "Tahoma", 8, #PB_Font_HighQuality)
    SetGadgetFont(#PB_Default, FontID(0))
  EndIf
  
  If CreateImageMenu(#Menu, WindowID(#Window), #PB_Menu_ModernLook)
    MenuTitle("File")
    MenuItem(#New,"New", ImageID(CatchImage(#PB_Any, ?New_icon)))
    MenuItem(#Open,"Open...", ImageID(CatchImage(#PB_Any, ?Open_icon)))
    MenuItem(#Save,"Save", ImageID(CatchImage(#PB_Any, ?Save_icon)))
    MenuItem(#Save_as,"Save as...", ImageID(CatchImage(#PB_Any, ?Save_as_icon)))
    MenuItem(#Export,"Export...", ImageID(CatchImage(#PB_Any, ?Export_icon)))
    MenuItem(#Export_as,"Export as...", ImageID(CatchImage(#PB_Any, ?Export_as_icon)))
    MenuItem(#Close,"Close", ImageID(CatchImage(#PB_Any, ?Close_icon)))
    MenuBar()
    MenuItem(#Parameters,"Parameters", ImageID(CatchImage(#PB_Any, ?Edit_icon)))
    MenuBar()
    MenuItem(#Quit,"Quit", ImageID(CatchImage(#PB_Any, ?Quit_icon)))
    MenuTitle("Tools")
    MenuItem(#Pen, "Pen", ImageID(CatchImage(#PB_Any, ?Pen_icon)))
    MenuItem(#Square, "Square", ImageID(CatchImage(#PB_Any, ?Square_icon)))
    MenuItem(#Fill, "Fill", ImageID(CatchImage(#PB_Any, ?Fill_icon)))
    MenuBar()
    MenuItem(#Zoom1, "Zoom*1", ImageID(CatchImage(#PB_Any, ?Zoom1_icon)))
    MenuItem(#Zoom2, "Zoom*2", ImageID(CatchImage(#PB_Any, ?Zoom2_icon)))
    MenuBar()
    MenuItem(#Grid, "Grid", ImageID(CatchImage(#PB_Any, ?Grid_icon)))
    MenuBar()
    MenuItem(#Tiles_editor,"Tiles editor", ImageID(CatchImage(#PB_Any, ?Tiles_editor_icon)))
    MenuItem(#Masks_editor,"Masks editor", ImageID(CatchImage(#PB_Any, ?Masks_editor_icon)))
    MenuBar()
    MenuItem(#Screenshot,"Screenshot", ImageID(CatchImage(#PB_Any, ?Screenshot_icon)))
    MenuTitle("Help")
    MenuItem(#About,"About...", ImageID(CatchImage(#PB_Any, ?Help_icon)))
    DisableMenuItem(#Menu, #Save, 1)
    DisableMenuItem(#Menu, #Save_as, 1)
    DisableMenuItem(#Menu, #Export, 1)
    DisableMenuItem(#Menu, #Export_as, 1)
    DisableMenuItem(#Menu, #Close, 1)
    DisableMenuItem(#Menu, #Parameters, 1)
    DisableMenuItem(#Menu, #Pen, 1)
    DisableMenuItem(#Menu, #Square, 1)
    DisableMenuItem(#Menu, #Fill, 1)
    DisableMenuItem(#Menu, #Zoom1, 1)
    DisableMenuItem(#Menu, #Zoom2, 1)
    DisableMenuItem(#Menu, #Grid, 1)
    DisableMenuItem(#Menu, #Screenshot, 1)
  EndIf
  
  If CreateToolBar(#ToolBar, WindowID(#Window))
    ToolBarImageButton(#New, ImageID(CatchImage(#PB_Any, ?New_icon)))
    ToolBarImageButton(#Open, ImageID(CatchImage(#PB_Any, ?Open_icon)))
    ToolBarImageButton(#Save, ImageID(CatchImage(#PB_Any, ?Save_icon)))
    ToolBarImageButton(#Save_as, ImageID(CatchImage(#PB_Any, ?Save_as_icon)))
    ToolBarImageButton(#Export, ImageID(CatchImage(#PB_Any, ?Export_icon)))
    ToolBarImageButton(#Export_as, ImageID(CatchImage(#PB_Any, ?Export_as_icon)))
    ToolBarImageButton(#Close, ImageID(CatchImage(#PB_Any, ?Close_icon)))
    ToolBarSeparator()
    ToolBarImageButton(#Parameters, ImageID(CatchImage(#PB_Any, ?Edit_icon)))
    ToolBarSeparator()
    ToolBarImageButton(#Pen, ImageID(CatchImage(#PB_Any, ?Pen_icon)), #PB_ToolBar_Toggle)
    ToolBarImageButton(#Square, ImageID(CatchImage(#PB_Any, ?Square_icon)), #PB_ToolBar_Toggle)
    ToolBarImageButton(#Fill, ImageID(CatchImage(#PB_Any, ?Fill_icon)), #PB_ToolBar_Toggle)
    ToolBarSeparator()
    ToolBarImageButton(#Zoom1, ImageID(CatchImage(#PB_Any, ?Zoom1_icon)), #PB_ToolBar_Toggle)
    ToolBarImageButton(#Zoom2, ImageID(CatchImage(#PB_Any, ?Zoom2_icon)), #PB_ToolBar_Toggle)
    ToolBarSeparator()
    ToolBarImageButton(#Grid, ImageID(CatchImage(#PB_Any, ?Grid_icon)), #PB_ToolBar_Toggle)
    ToolBarSeparator()
    ToolBarImageButton(#Tiles_editor, ImageID(CatchImage(#PB_Any, ?Tiles_editor_icon)))
    ToolBarImageButton(#Masks_editor, ImageID(CatchImage(#PB_Any, ?Masks_editor_icon)))
    ToolBarSeparator()
    ToolBarImageButton(#Screenshot, ImageID(CatchImage(#PB_Any, ?Screenshot_icon)))
    ToolBarToolTip(#ToolBar, #New, "New")
    ToolBarToolTip(#ToolBar, #Open, "Open...")
    ToolBarToolTip(#ToolBar, #Save, "Save")
    ToolBarToolTip(#ToolBar, #Save_as, "Save as...")
    ToolBarToolTip(#ToolBar, #Export, "Export...")
    ToolBarToolTip(#ToolBar, #Export_as, "Export as...")
    ToolBarToolTip(#ToolBar, #Close, "Close")
    ToolBarToolTip(#ToolBar, #Parameters, "Parameters")
    ToolBarToolTip(#ToolBar, #Pen, "Pen")
    ToolBarToolTip(#ToolBar, #Square, "Square")
    ToolBarToolTip(#ToolBar, #Fill, "Fill")
    ToolBarToolTip(#ToolBar, #Zoom1, "Zoom *1")
    ToolBarToolTip(#ToolBar, #Zoom2, "Zoom *2")
    ToolBarToolTip(#ToolBar, #Grid, "Grid")
    ToolBarToolTip(#ToolBar, #Tiles_editor, "Tiles editor")
    ToolBarToolTip(#ToolBar, #Masks_editor, "Masks editor")
    ToolBarToolTip(#ToolBar, #Screenshot, "Screenshot")
    DisableToolBarButton(#ToolBar, #Save, 1)
    DisableToolBarButton(#ToolBar, #Save_as, 1)
    DisableToolBarButton(#ToolBar, #Export, 1)
    DisableToolBarButton(#ToolBar, #Export_as, 1)
    DisableToolBarButton(#ToolBar, #Close, 1)
    DisableToolBarButton(#ToolBar, #Parameters, 1)
    DisableToolBarButton(#ToolBar, #Pen, 1)
    DisableToolBarButton(#ToolBar, #Square, 1)
    DisableToolBarButton(#ToolBar, #Fill, 1)
    DisableToolBarButton(#ToolBar, #Zoom1, 1)
    DisableToolBarButton(#ToolBar, #Zoom2, 1)
    DisableToolBarButton(#ToolBar, #Grid, 1)
    DisableToolBarButton(#ToolBar, #Screenshot, 1)
  EndIf
  
  If OpenPreferences(#CONFIG_FILE) = 0
    CreatePreferences(#CONFIG_FILE)
    PreferenceGroup("brush")
    WritePreferenceLong("brushes", 0)
    PreferenceComment("Brushes list")
    PreferenceGroup("mask")
    WritePreferenceLong("masks", 0)
    PreferenceComment("Masks list")
    PreferenceGroup("tile")
    WritePreferenceLong("tiles", 0)
    PreferenceComment("Tiles list")
  EndIf

  Protected i.l = 0
  If PreferenceGroup("brush")
    While ReadPreferenceLong("brushes", 0)-i
      brushes(Str(i))\name = ReadPreferenceString(Str(i)+".name", "")
      brushes(Str(i))\tile = ReadPreferenceLong(Str(i)+".tile", 0)
      brushes(Str(i))\animated = ReadPreferenceLong(Str(i)+".animated", 0)
      brushes(Str(i))\bridge = ReadPreferenceLong(Str(i)+".bridge", 0)
      brushes(Str(i))\offset = ReadPreferenceLong(Str(i)+".offset", 0)
      brushes(Str(i))\notpassable = ReadPreferenceLong(Str(i)+".notpassable", 0)
      brushes(Str(i))\height = ReadPreferenceLong(Str(i)+".height", 0)
      brushes(Str(i))\mask = ReadPreferenceLong(Str(i)+".mask", 0)
      brushes(Str(i))\collision = ReadPreferenceString(Str(i)+".collision", "")
      brushes(Str(i))\interaction = ReadPreferenceString(Str(i)+".interaction", "")
      brushes(Str(i))\location = ReadPreferenceLong(Str(i)+".location", 0)
      i+1
    Wend
  EndIf
  
  i = 0
  If PreferenceGroup("mask")
    While ReadPreferenceLong("masks", 0)-i
      masks(Str(i)) = ReadPreferenceString(Str(i), "")
      i+1
    Wend
  EndIf

  i = 0
  If PreferenceGroup("tile")
    While ReadPreferenceLong("tiles", 0)-i
      tiles(Str(i)) = ReadPreferenceString(Str(i), "")
      i+1
    Wend
  EndIf
EndProcedure

Procedure InitWorkArea()
  If CreateStatusBar(#StatusBar, WindowID(#Window))
    AddStatusBarField(#StatusBarFirstFieldWidth)
    AddStatusBarField(25)
    AddStatusBarField(#PB_Ignore)
  EndIf
  
  CreateImage(#MapImage, map_\w*#TILE_WIDTH, map_\h*#TILE_HEIGHT)
  
  DisableMenuItem(#Menu, #Save_as, 0)
  DisableMenuItem(#Menu, #Export, 0)
  DisableMenuItem(#Menu, #Export_as, 0)
  DisableMenuItem(#Menu, #Close, 0)
  DisableMenuItem(#Menu, #Parameters, 0)
  DisableMenuItem(#Menu, #Pen, 0)
  DisableMenuItem(#Menu, #Square, 0)
  DisableMenuItem(#Menu, #Fill, 0)
  DisableMenuItem(#Menu, #Zoom1, 0)
  DisableMenuItem(#Menu, #Zoom2, 0)
  DisableMenuItem(#Menu, #Grid, 0)
  DisableMenuItem(#Menu, #Screenshot, 0)
  DisableToolBarButton(#ToolBar, #Save_as, 0)
  DisableToolBarButton(#ToolBar, #Export, 0)
  DisableToolBarButton(#ToolBar, #Export_as, 0)
  DisableToolBarButton(#ToolBar, #Close, 0)
  DisableToolBarButton(#ToolBar, #Parameters, 0)
  DisableToolBarButton(#ToolBar, #Pen, 0)
  DisableToolBarButton(#ToolBar, #Square, 0)
  DisableToolBarButton(#ToolBar, #Fill, 0)
  DisableToolBarButton(#ToolBar, #Zoom1, 0)
  DisableToolBarButton(#ToolBar, #Zoom2, 0)
  DisableToolBarButton(#ToolBar, #Grid, 0)
  DisableToolBarButton(#ToolBar, #Screenshot, 0)
  SetToolBarButtonState(#ToolBar, #Pen, 1)
  SetToolBarButtonState(#ToolBar, #Zoom1, 1)
  tool = 1
  zoom = 1
  grid = 0
  brushes_cursor\id = 0
  map_cursor\x = -2
  map_cursor\y = -2
  
  UseGadgetList(WindowID(#Window))

  ListIconGadget(#BrushesListIcon, 0, 0, 0, 0, "Brush", #BrushesColumn1_w, #PB_ListIcon_FullRowSelect | #PB_ListIcon_AlwaysShowSelection)
  AddGadgetColumn(#BrushesListIcon, 2, "ID", #BrushesColumn2_w)
  AddGadgetColumn(#BrushesListIcon, 3, "name", #BrushesColumn3_w)
  AddGadgetColumn(#BrushesListIcon, 4, "tile", #BrushesColumn4_w)
  AddGadgetColumn(#BrushesListIcon, 5, "animated", #BrushesColumn5_w)
  AddGadgetColumn(#BrushesListIcon, 6, "bridge", #BrushesColumn6_w)
  AddGadgetColumn(#BrushesListIcon, 7, "offset", #BrushesColumn7_w)
  AddGadgetColumn(#BrushesListIcon, 8, "notpassable", #BrushesColumn8_w)
  AddGadgetColumn(#BrushesListIcon, 9, "height", #BrushesColumn9_w)
  AddGadgetColumn(#BrushesListIcon, 10, "mask", #BrushesColumn10_w)
  AddGadgetColumn(#BrushesListIcon, 11, "collision", #BrushesColumn11_w)
  AddGadgetColumn(#BrushesListIcon, 12, "interaction", #BrushesColumn12_w)
  RefreshBrushes()

  ButtonImageGadget(#UpButton2, 0, 0, 0, 0, ImageID(CatchImage(#PB_Any, ?Up_icon)))
  GadgetToolTip(#UpButton2, "Up")
  DisableGadget(#UpButton2, 1)
  ButtonImageGadget(#DownButton2, 0, 0, 0, 0, ImageID(CatchImage(#PB_Any, ?Down_icon)))
  GadgetToolTip(#DownButton2, "Down")
  DisableGadget(#DownButton2, 1)
  ButtonImageGadget(#GotoButton, 0, 0, 0, 0, ImageID(CatchImage(#PB_Any, ?Goto_icon)))
  GadgetToolTip(#GotoButton, "Goto...")
  DisableGadget(#GotoButton, 1)
  ButtonImageGadget(#AddButton2, 0, 0, 0, 0, ImageID(CatchImage(#PB_Any, ?Plus_icon)))
  GadgetToolTip(#AddButton2, "Add")
  ButtonImageGadget(#RemoveButton2, 0, 0, 0, 0, ImageID(CatchImage(#PB_Any, ?Minus_icon)))
  GadgetToolTip(#RemoveButton2, "Remove")
  DisableGadget(#RemoveButton2, 1)
  ButtonImageGadget(#EditButton, 0, 0, 0, 0, ImageID(CatchImage(#PB_Any, ?Edit_icon)))
  GadgetToolTip(#EditButton, "Edit")
  DisableGadget(#EditButton, 1)
  ButtonImageGadget(#OutsideButton, 0, 0, 0, 0, ImageID(CatchImage(#PB_Any, ?Outside_icon)), #PB_Button_Toggle)
  GadgetToolTip(#OutsideButton, "Outside brushes")
  brushes_cursor\location = 0
  SetGadgetState(#OutsideButton, 1)
  ButtonImageGadget(#InsideButton, 0, 0, 0, 0, ImageID(CatchImage(#PB_Any, ?Inside_icon)), #PB_Button_Toggle)
  GadgetToolTip(#InsideButton, "Inside brushes")

  ScrollAreaGadget(#MapScrollArea, 0, 0, 0, 0, ImageWidth(#MapImage), ImageHeight(#MapImage), 1, #PB_ScrollArea_Single|#PB_ScrollArea_Center)
  CanvasGadget(#MapGadget, 0, 0, ImageWidth(#MapImage), ImageHeight(#MapImage))
  CloseGadgetList()

  SplitterGadget(#SplitterGadget, 0, 0, 0, 0, #BrushesListIcon, #MapScrollArea, #PB_Splitter_Vertical | #PB_Splitter_Separator | #PB_Splitter_FirstFixed)
  SetGadgetAttribute(#SplitterGadget, #PB_Splitter_FirstMinimumSize, #BrushesListIcon_w)
  SetGadgetState(#SplitterGadget, #BrushesListIcon_w)
  
  ResizeWindow_()
  ProcedureReturn 1
EndProcedure

Procedure ResizeWindow_()
  ResizeGadget(#SplitterGadget, #SplitterGadget_x, ToolBarHeight(#ToolBar)+1, WindowWidth(#Window), WindowHeight(#Window)-MenuHeight()-ToolBarHeight(#ToolBar)-1-StatusBarHeight(#StatusBar)-#UpButton2_h-#BrushesListIconHeight)
  ResizeGadget(#UpButton2, #UpButton2_x, GadgetY(#SplitterGadget)+GadgetHeight(#SplitterGadget), #UpButton2_w, #UpButton2_h)
  ResizeGadget(#DownButton2, #DownButton2_x, GadgetY(#UpButton2), #DownButton2_w, #DownButton2_h)
  ResizeGadget(#GotoButton, #GotoButton_x, GadgetY(#DownButton2), #GotoButton_w, #GotoButton_h)
  ResizeGadget(#AddButton2, #AddButton2_x, GadgetY(#GotoButton), #AddButton2_w, #AddButton2_h)
  ResizeGadget(#RemoveButton2, #RemoveButton2_x, GadgetY(#AddButton2), #RemoveButton2_w, #RemoveButton2_h)
  ResizeGadget(#EditButton, #EditButton_x, GadgetY(#RemoveButton2), #EditButton_w, #EditButton_h)
  ResizeGadget(#OutsideButton, #OutsideButton_x, GadgetY(#EditButton), #OutsideButton_w, #OutsideButton_h)
  ResizeGadget(#InsideButton, #InsideButton_x, GadgetY(#OutsideButton), #InsideButton_w, #InsideButton_h)
EndProcedure

Procedure RefreshBrushes()
  ClearGadgetItems(#BrushesListIcon)
  CopyMap(brushes(), brushes_temp())
  ClearMap(brushes())
  Protected i.l = 0
  ForEach brushes_temp()
    brushes(Str(i))\name = brushes_temp()\name
    brushes(Str(i))\tile = brushes_temp()\tile
    brushes(Str(i))\animated = brushes_temp()\animated
    brushes(Str(i))\bridge = brushes_temp()\bridge
    brushes(Str(i))\offset = brushes_temp()\offset
    brushes(Str(i))\notpassable = brushes_temp()\notpassable
    brushes(Str(i))\height = brushes_temp()\height
    brushes(Str(i))\mask = brushes_temp()\mask
    brushes(Str(i))\collision = brushes_temp()\collision
    brushes(Str(i))\interaction = brushes_temp()\interaction
    brushes(Str(i))\location = brushes_temp()\location
    If brushes(Str(i))\location = brushes_cursor\location
      LoadImage(Val(MapKey(brushes())), "tiles"+#Path_separator+tiles(Str(brushes()\tile)))
      AddGadgetItem(#BrushesListIcon, -1, Chr(10)+MapKey(brushes())+Chr(10)+brushes()\name+Chr(10)+tiles(Str(brushes()\tile))+Chr(10)+Str(brushes()\animated)+Chr(10)+Str(brushes()\bridge)+Chr(10)+Str(brushes()\offset)+Chr(10)+Str(brushes()\notpassable)+Chr(10)+Str(brushes()\height)+Chr(10)+Str(brushes()\mask)+Chr(10)+RemoveString(brushes()\collision, Chr(10))+Chr(10)+RemoveString(brushes()\interaction, Chr(10)), ImageID(Val(MapKey(brushes()))))
    EndIf
    i+1
  Next
EndProcedure

DataSection
  New_icon:
  IncludeBinary "icons"+#Path_separator+"new.png"
  Open_icon:
  IncludeBinary "icons"+#Path_separator+"open.png"
  Save_icon:
  IncludeBinary "icons"+#Path_separator+"save.png"
  Save_as_icon:
  IncludeBinary "icons"+#Path_separator+"save_as.png"
  Export_icon:
  IncludeBinary "icons"+#Path_separator+"export.png"
  Export_as_icon:
  IncludeBinary "icons"+#Path_separator+"export_as.png"
  Close_icon:
  IncludeBinary "icons"+#Path_separator+"close.png"
  Quit_icon:
  IncludeBinary "icons"+#Path_separator+"quit.png"
  Pen_icon:
  IncludeBinary "icons"+#Path_separator+"pen.png"
  Square_icon:
  IncludeBinary "icons"+#Path_separator+"square.png"
  Fill_icon:
  IncludeBinary "icons"+#Path_separator+"fill.png"
  Zoom1_icon:
  IncludeBinary "icons"+#Path_separator+"zoom1.png"
  Zoom2_icon:
  IncludeBinary "icons"+#Path_separator+"zoom2.png"
  Grid_icon:
  IncludeBinary "icons"+#Path_separator+"grid.png"
  Tiles_editor_icon:
  IncludeBinary "icons"+#Path_separator+"tiles_editor.png"
  Masks_editor_icon:
  IncludeBinary "icons"+#Path_separator+"masks_editor.png"
  Screenshot_icon:
  IncludeBinary "icons"+#Path_separator+"screenshot.png"
  Help_icon:
  IncludeBinary "icons"+#Path_separator+"help.png"
  Up_icon:
  IncludeBinary "icons"+#Path_separator+"up.png"
  Down_icon:
  IncludeBinary "icons"+#Path_separator+"down.png"
  Goto_icon:
  IncludeBinary "icons"+#Path_separator+"up_down.png"
  Plus_icon:
  IncludeBinary "icons"+#Path_separator+"plus.png"
  Minus_icon:
  IncludeBinary "icons"+#Path_separator+"minus.png"
  Edit_icon:
  IncludeBinary "icons"+#Path_separator+"edit.png"
  Outside_icon:
  IncludeBinary "icons"+#Path_separator+"outside.png"
  Inside_icon:
  IncludeBinary "icons"+#Path_separator+"inside.png"
EndDataSection
; IDE Options = PureBasic 5.11 (Windows - x86)
; CursorPosition = 288
; FirstLine = 274
; Folding = -
; UseMainFile = main.pb
; CurrentDirectory = ..\